unit EuroRechner_MainForm;

(*

EuroRechner version 3.0
Copyright (C) 2000,2011 Daniel Schwinn / düsi computer software

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
Version 2 as published by the Free Software Foundation

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.

düsi computer software
Daniel Schwinn
Römerturmstraße 25
73547 Lorch
Germany

www.EuroRechner.de
i n f o (a) d u e s i c o m p u t e r s o f t w a r e . d e

*)

{$mode objfpc}{$H+}

interface

uses
  Classes, SysUtils, FileUtil, LResources, Forms, Controls, Graphics, Dialogs,
  ExtCtrls, StdCtrls;

type

  { TMain_Form }

  TMain_Form = class(TForm)
    Edit_EEK: TEdit;
    Edit_FIM: TEdit;
    Edit_ATS: TEdit;
    Edit_SIT: TEdit;
    Edit_GRD: TEdit;
    Edit_ITL: TEdit;
    Edit_ESP: TEdit;
    Edit_PTE: TEdit;
    Edit_MTL: TEdit;
    Edit_CYP: TEdit;
    Edit_EUR: TEdit;
    Edit_IEP: TEdit;
    Edit_NLG: TEdit;
    Edit_DEM: TEdit;
    Edit_BEF: TEdit;
    Edit_SKK: TEdit;
    Edit_LUF: TEdit;
    Edit_FRF: TEdit;
    BackgroundImage: TImage;
    procedure BackgroundImageClick(Sender: TObject);
    procedure Edit_Changed(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure FormShow(Sender: TObject);
  private
    stop_updates:boolean;
    function formatNumber(value:extended;stellen:integer;max_len:integer):string;
    function getEditValue(field:TEdit;exchange_rate:extended):extended;
    procedure fillEditValue(field:TEdit;value:extended;exchange_rate:extended;nk_stellen:integer;max_len:integer);
    function checkNumber(txt:string):string;
  end;

var
  Main_Form: TMain_Form;

implementation

{ TMain_Form }

//Wechselkurse gegenüber dem Euro
const
  RATE_EUR:extended=1.00;
  RATE_FIM:extended=5.94573;
  RATE_IEP:extended=0.787564;
  RATE_NLG:extended=2.20371;
  RATE_DEM:extended=1.95583;
  RATE_BEF:extended=40.3399;
  RATE_SKK:extended=30.1260;
  RATE_LUF:extended=40.3399;
  RATE_ATS:extended=13.7603;
  RATE_FRF:extended=6.55957;
  RATE_SIT:extended=239.64;
  RATE_GRD:extended=340.75;
  RATE_ITL:extended=1936.27;
  RATE_ESP:extended=166.386;
  RATE_PTE:extended=200.482;
  RATE_MTL:extended=0.4293;
  RATE_CYP:extended=0.585274;
  RATE_EEK:extended=15.6466;

//Maximaler Platz im Edit-Feld in Zeichen, Feld hat 8 Pixel Breite je Zeichen
//Bemessung der Felder mit Platz für Umrechnung von 99999999.99 EUR
const
  MAXLEN_EUR:integer=11; // 8+2 Stellen
  MAXLEN_FIM:integer=12; // 9+2 Stellen
  MAXLEN_IEP:integer=11; // 8+2 Stellen
  MAXLEN_NLG:integer=12; // 9+2 Stellen
  MAXLEN_DEM:integer=12; // 9+2 Stellen
  MAXLEN_BEF:integer=11; // 11+0 Stellen
  MAXLEN_SKK:integer=13; // 10+2 Stellen
  MAXLEN_LUF:integer=11; // 11+0 Stellen
  MAXLEN_ATS:integer=13; // 10+2 Stellen
  MAXLEN_FRF:integer=12; // 9+2 Stellen
  MAXLEN_SIT:integer=14; // 11+2 Stellen
  MAXLEN_GRD:integer=11; // 11+0 Stellen
  MAXLEN_ITL:integer=12; // 12+0 Stellen
  MAXLEN_ESP:integer=11; // 11+0 Stellen
  MAXLEN_PTE:integer=14; // 11+2 Stellen
  MAXLEN_MTL:integer=12; // 8+3 Stellen
  MAXLEN_CYP:integer=12; // 9+2 Stellen
  MAXLEN_EEK:integer=13; // 10+2 Stellen

procedure TMain_Form.FormCreate(Sender: TObject);
begin
  Width:=750;
  Height:=700;
  stop_updates:=false;
  Edit_EUR.Text:='1.00';
  Edit_EUR.MaxLength:=MAXLEN_EUR;
  Edit_FIM.MaxLength:=MAXLEN_FIM;
  Edit_IEP.MaxLength:=MAXLEN_IEP;
  Edit_NLG.MaxLength:=MAXLEN_NLG;
  Edit_DEM.MaxLength:=MAXLEN_DEM;
  Edit_BEF.MaxLength:=MAXLEN_BEF;
  Edit_SKK.MaxLength:=MAXLEN_SKK;
  Edit_LUF.MaxLength:=MAXLEN_LUF;
  Edit_ATS.MaxLength:=MAXLEN_ATS;
  Edit_FRF.MaxLength:=MAXLEN_FRF;
  Edit_SIT.MaxLength:=MAXLEN_SIT;
  Edit_GRD.MaxLength:=MAXLEN_GRD;
  Edit_ITL.MaxLength:=MAXLEN_ITL;
  Edit_ESP.MaxLength:=MAXLEN_ESP;
  Edit_PTE.MaxLength:=MAXLEN_PTE;
  Edit_MTL.MaxLength:=MAXLEN_MTL;
  Edit_CYP.MaxLength:=MAXLEN_CYP;
  Edit_EEK.MaxLength:=MAXLEN_EEK;
end;

procedure TMain_Form.FormShow(Sender: TObject);
begin
  Edit_EUR.SetFocus;
  Edit_EUR.SelectAll;
end;

procedure TMain_Form.Edit_Changed(Sender: TObject);
var
  eur_value:extended;
begin
  if stop_updates then begin
    exit;
  end;
  if Sender=Edit_EUR then begin
    eur_value:=getEditValue(Edit_EUR,RATE_EUR);
  end else if Sender=Edit_FIM then begin
    eur_value:=getEditValue(Edit_FIM,RATE_FIM);
  end else if Sender=Edit_IEP then begin
    eur_value:=getEditValue(Edit_IEP,RATE_IEP);
  end else if Sender=Edit_NLG then begin
    eur_value:=getEditValue(Edit_NLG,RATE_NLG);
  end else if Sender=Edit_DEM then begin
    eur_value:=getEditValue(Edit_DEM,RATE_DEM);
  end else if Sender=Edit_BEF then begin
    eur_value:=getEditValue(Edit_BEF,RATE_BEF);
  end else if Sender=Edit_SKK then begin
    eur_value:=getEditValue(Edit_SKK,RATE_SKK);
  end else if Sender=Edit_LUF then begin
    eur_value:=getEditValue(Edit_LUF,RATE_LUF);
  end else if Sender=Edit_ATS then begin
    eur_value:=getEditValue(Edit_ATS,RATE_ATS);
  end else if Sender=Edit_FRF then begin
    eur_value:=getEditValue(Edit_FRF,RATE_FRF);
  end else if Sender=Edit_SIT then begin
    eur_value:=getEditValue(Edit_SIT,RATE_SIT);
  end else if Sender=Edit_GRD then begin
    eur_value:=getEditValue(Edit_GRD,RATE_GRD);
  end else if Sender=Edit_ITL then begin
    eur_value:=getEditValue(Edit_ITL,RATE_ITL);
  end else if Sender=Edit_ESP then begin
    eur_value:=getEditValue(Edit_ESP,RATE_ESP);
  end else if Sender=Edit_PTE then begin
    eur_value:=getEditValue(Edit_PTE,RATE_PTE);
  end else if Sender=Edit_MTL then begin
    eur_value:=getEditValue(Edit_MTL,RATE_MTL);
  end else if Sender=Edit_CYP then begin
    eur_value:=getEditValue(Edit_CYP,RATE_CYP);
  end else if Sender=Edit_EEK then begin
    eur_value:=getEditValue(Edit_EEK,RATE_EEK);
  end else begin
    eur_value:=0;
  end;
  stop_updates:=true;
  try
    if Sender <> Edit_EUR then begin
      fillEditValue(Edit_EUR,eur_value,RATE_EUR,2,MAXLEN_EUR);
    end;
    if Sender <> Edit_FIM then begin
      fillEditValue(Edit_FIM,eur_value,RATE_FIM,2,MAXLEN_FIM);
    end;
    if Sender <> Edit_IEP then begin
      fillEditValue(Edit_IEP,eur_value,RATE_IEP,2,MAXLEN_IEP);
    end;
    if Sender <> Edit_NLG then begin
      fillEditValue(Edit_NLG,eur_value,RATE_NLG,2,MAXLEN_NLG);
    end;
    if Sender <> Edit_DEM then begin
      fillEditValue(Edit_DEM,eur_value,RATE_DEM,2,MAXLEN_DEM);
    end;
    if Sender <> Edit_BEF then begin
      fillEditValue(Edit_BEF,eur_value,RATE_BEF,0,MAXLEN_BEF);
    end;
    if Sender <> Edit_SKK then begin
      fillEditValue(Edit_SKK,eur_value,RATE_SKK,2,MAXLEN_SKK);
    end;
    if Sender <> Edit_LUF then begin
      fillEditValue(Edit_LUF,eur_value,RATE_LUF,0,MAXLEN_LUF);
    end;
    if Sender <> Edit_ATS then begin
      fillEditValue(Edit_ATS,eur_value,RATE_ATS,2,MAXLEN_ATS);
    end;
    if Sender <> Edit_FRF then begin
      fillEditValue(Edit_FRF,eur_value,RATE_FRF,2,MAXLEN_FRF);
    end;
    if Sender <> Edit_SIT then begin
      fillEditValue(Edit_SIT,eur_value,RATE_SIT,2,MAXLEN_SIT);
    end;
    if Sender <> Edit_GRD then begin
      fillEditValue(Edit_GRD,eur_value,RATE_GRD,0,MAXLEN_GRD);
    end;
    if Sender <> Edit_ITL then begin
      fillEditValue(Edit_ITL,eur_value,RATE_ITL,0,MAXLEN_ITL);
    end;
    if Sender <> Edit_ESP then begin
      fillEditValue(Edit_ESP,eur_value,RATE_ESP,0,MAXLEN_ESP);
    end;
    if Sender <> Edit_PTE then begin
      fillEditValue(Edit_PTE,eur_value,RATE_PTE,2,MAXLEN_PTE);
    end;
    if Sender <> Edit_MTL then begin
      fillEditValue(Edit_MTL,eur_value,RATE_MTL,3,MAXLEN_MTL);
    end;
    if Sender <> Edit_CYP then begin
      fillEditValue(Edit_CYP,eur_value,RATE_CYP,2,MAXLEN_CYP);
    end;
    if Sender <> Edit_EEK then begin
      fillEditValue(Edit_EEK,eur_value,RATE_EEK,2,MAXLEN_EEK);
    end;
  finally
    stop_updates:=false;
  end;
end;

procedure TMain_Form.BackgroundImageClick(Sender: TObject);
begin

end;

function TMain_Form.checkNumber(txt:string):string;
var
  dp_count:integer;
  n:integer;
  c:char;
begin
  result:='';
  dp_count:=0;
  for n:=1 to length(txt) do begin
    c:=txt[n];
    case c of
    '0'..'9':begin
        result:=result+c;
      end;
    '.',',':begin
        inc(dp_count);
        if dp_count>1 then begin
          result:='';
          exit;
        end;
        result:=result+DecimalSeparator;
      end;
    else
      result:='';
      exit;
    end;
  end;
end;

function TMain_Form.formatNumber(value:extended;stellen:integer;max_len:integer):string;
begin
  case stellen of
  3:value:=int(value*1000.0+0.5)/1000.0;
  2:value:=int(value*100.0+0.5)/100.0;
  0:value:=int(value+0.5);
  end;
  value:=value+0.0001;
  result:=trim(format('%14.*f',[stellen,value]));
  if length(result)>max_len then begin
    result:='---';
  end;
end;

function TMain_Form.getEditValue(field:TEdit;exchange_rate:extended):extended;
var
  txt:string;
  amount:extended;
begin
  txt:=checkNumber(field.Text);
  if txt='' then begin
    field.Text:='';
    result:=0;
    exit;
  end;
  amount:=StrToFloatDef(txt,0);
  result:=amount/exchange_rate;
end;

procedure TMain_Form.fillEditValue(field:TEdit;value:extended;exchange_rate:extended;nk_stellen:integer;max_len:integer);
var
  changed_value:extended;
begin
  if value=0 then begin
    field.Text:='';
    exit;
  end;
  changed_value:=value*exchange_rate;
  field.Text:=formatNumber(changed_value,nk_stellen,max_len);
end;


initialization
  {$I eurorechner_mainform.lrs}

end.

